<{* Publisher Sidebar Widget Template - Kompakt Yan Menü Görünümü *}>

<{if $publisher_count > 0}>
    <div class="publisher-sidebar-widget">
        <{foreach item=item from=$publisher_items}>
            <div class="sidebar-item">
                <{if $item.thumb}>
                    <div class="sidebar-thumb">
                        <a href="<{$item.link}>" title="<{$item.title}>">
                            <img src="<{$item.thumb}>" alt="<{$item.title}>" />
                        </a>
                    </div>
                <{/if}>
                
                <div class="sidebar-content">
                    <h5 class="sidebar-title">
                        <a href="<{$item.link}>" title="<{$item.title}>">
                            <{$item.title|truncate:40:"..."}>
                        </a>
                    </h5>
                    
                    <{if $item.votes > 0}>
                        <div class="sidebar-rating">
                            <span class="rating-stars">
                                <{assign var="fullStars" value=$item.rating|floor}>
                                <{section name=star loop=5}>
                                    <{if $smarty.section.star.index < $fullStars}>★<{else}>☆<{/if}>
                                <{/section}>
                            </span>
                            <span class="rating-value"><{$item.rating}></span>
                        </div>
                    <{/if}>
                    
                    <div class="sidebar-meta">
                        <span class="meta-views">
                            <i class="fa fa-eye"></i> <{$item.counter}>
                        </span>
                        <span class="meta-date">
                            <i class="fa fa-clock-o"></i> <{$item.date_short}>
                        </span>
                    </div>
                </div>
                <div style="clear:both;"></div>
            </div>
        <{/foreach}>
    </div>
<{else}>
    <div class="no-content">
        <p>İçerik bulunamadı.</p>
    </div>
<{/if}>

<style>
.publisher-sidebar-widget {
    background: #fff;
    border-radius: 8px;
    padding: 15px;
}

.sidebar-item {
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f0f0f0;
}

.sidebar-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.sidebar-thumb {
    float: left;
    width: 80px;
    height: 80px;
    margin-right: 12px;
    overflow: hidden;
    border-radius: 5px;
}

.sidebar-thumb img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.sidebar-item:hover .sidebar-thumb img {
    transform: scale(1.1);
}

.sidebar-content {
    overflow: hidden;
}

.sidebar-title {
    margin: 0 0 8px 0;
    font-size: 14px;
    font-weight: 600;
    line-height: 1.4;
}

.sidebar-title a {
    color: #333;
    text-decoration: none;
}

.sidebar-title a:hover {
    color: #0066cc;
}

.sidebar-rating {
    margin-bottom: 6px;
    font-size: 12px;
}

.rating-stars {
    color: #ffd700;
    margin-right: 5px;
}

.rating-value {
    color: #666;
    font-weight: 600;
}

.sidebar-meta {
    font-size: 11px;
    color: #999;
}

.sidebar-meta span {
    margin-right: 10px;
}

.sidebar-meta i {
    margin-right: 3px;
}

.no-content {
    padding: 20px;
    text-align: center;
    color: #999;
}
</style>
